local function add_structure(f)
	if(f) then
		f.shape_table_data = 
		{
			{
				file  	    = f.ShapeName,
				life	    = f.Life,
				username    = f.Name,
				desrt       = f.ShapeNameDestr or "self",
			        classname   = f.classname   or "lLandVehicle",
				positioning = f.positioning or "ONLYHEIGTH"	--available: {"BYNORMAL", "ONLYHEIGTH", "BY_XZ", "ADD_HEIGTH"}
			}
		}
		if f.ShapeNameDestr then
			f.shape_table_data[#f.shape_table_data + 1] = 
			{
				name  = f.ShapeName,
				file  = f.ShapeNameDestr,	
			}
		end
		
		
		--f.mapclasskey = "P0091000022";
		if f.keynum then
			f.mapclasskey = f.keynum
		else
			f.mapclasskey = "P0091000076"
		end

		if f.attribute then

		else
			f.attribute = {wsType_Static, wsType_Standing} -- if 'attribute' == nil then insertion will be aborted
		end

		if f.conf_fire then
			f.visual = f.conf_fire
		end

		if f.conf_animation then
			f.animation_arguments = f.conf_animation
		end
		
		add_surface_unit(f)
		GT = nil;
	else
		error("Can't add Riza24 structure(SmallBase.lua)")
	end;
end

--****************************************************************
-- Riz24_PrivateSmallBase
--
-- 水上に置けるSmallBase(ヘリパッドになっているが固定翼が運用できる滑走路(SkyJump))
--
add_structure({
	Name 		 	=	"R24G PrivateAirfield Small",
	DisplayName  	=	_("R24G Private Airfield Small"),
	ShapeName	 	=	"Riz24_PrivateSmallBase",
	desrt		 	=	"Riz24_PrivateSmallBase",
	Life		 	=	10000,
	Rate		 	=	100,
	--category     	=	'Fortification',
	SeaObject	 	=	True,
	isPutToWater 	=	True,
	positioning  	=	"ONLYHEIGTH",
	--classname    	=	"lStandartStructure",
	category     =  'Heliport',
	classname    =  "lHeliport",

	-- ??? edm pad connector or HelicopterSpawnTerminal?
	numParking		= 4,
	Plane_Num_		= 0,	-- Real value = 0 (4 Helicopters )
	Helicopter_Num_	= 4,	-- Real value = 4 Helicopters

	--fire
	conf_fire = {
		fire_size = 0, --relative burning size
		fire_pos = {0,0,0},
		fire_time = 0, --burning time (seconds)
	},
	time_agony = 180,

	-- animation
	conf_animation = {
	    headlights = 1,
	},
})
